'--------------------------------------------
' CSUB cLTrim and cRTrim 
' requires MMBasic for CMM2 V5.05.04 or later
' Syntax for CFunction header:
'   cLtrim STRING, STRING
'   cRtrim STRING, STRING
' 
' eg a$="   Hello World"
'    cLtrim(a$) or cLtrim(a$," ") or cLtrim(a$,"0")
'    PRINT a$ 
'--> "Hello World"
'
'// Note: doesn't work for string literals 
'// eg cLtrim("   test"," ")
'// use Function 'Ltrim("   test")' instead
'--------------------------------------------
' For the TBS-Forum 12.09.2020 v1.02
'--------------------------------------------
Option explicit
DIM INTEGER nLoops,i
DIM STRING a$,x$,z$
DIM FLOAT t
nLoops=1000
cls


x$="    Hello World!    "

font 3
Print " TRIM TEST + DEMONSTRATION"
font 1
Print
Print "Input string            Length     Loops"
Print ">"x$"<",Len(x$)"       "nLoops
Print "-------------------------------------------"

z$=x$

Timer=0
For i = 1 To nLoops
x$=z$

Next i
t=timer
'Print "Time for empty loop ";t/nLoops*1000;"us (x$=z$ only)"
'Print 


Timer=0
For i = 1 To nLoops
x$=z$
cRtrim(x$)
Next i
Print "Time for cRtrim:    ";(Timer-t)/nLoops*1000;"us (CSUB)"
Print ">";x$;"<",Len(x$)
Print

Timer=0
For i = 1 To nLoops
x$=z$
cltrim(x$)
Next i
Print "Time for cLtrim:    ";(Timer-t)/nLoops*1000;"us (CSUB)"
Print ">";x$;"<",Len(x$)
Print

Timer=0
For i = 1 To nLoops
x$=z$
ctrim(x$)
Next i
Print "Time for cTRIM:    ";(Timer-t)/nLoops*1000;"us (CSUB)"
Print ">";x$;"<",Len(x$)
Print

Timer=0
For i = 1 To nLoops
x$=z$
a$=rtrim(x$)
Next i
Print "Time for RTRIM():  ";(Timer-t)/nLoops*1000;"us (Function Rtrim)"
Print ">";a$;"<",Len(a$)
Print

Timer=0
For i = 1 To nLoops
x$=z$
a$=ltrim(x$)
Next i
Print "Time for LTRIM():  ";(Timer-t)/nLoops*1000;"us (Function Ltrim)"
Print ">";a$;"<",Len(a$)
Print

Timer=0
For i = 1 To nLoops
x$=z$
a$=trim(x$)
Next i
Print "Time for TRIM():   ";(Timer-t)/nLoops*1000;"us (Function cLtrim+cRtrim)"
Print ">";a$;"<",Len(a$)

Print "-------------------------------------------"

Timer=0
For i = 1 To nLoops

Next i
t=timer

Print "String = '        12345678'"
Timer=0
For i = 1 To nLoops
a$=ltrim("     12345678") ' string literal, works only with Function
Next i
Print "Time for LTRIM()  :";(Timer-t)/nLoops*1000;"us (string literal)"
Print ">";a$;"<",Len(a$)


x$="0000000012345678" 
z$=x$

Timer=0
For i = 1 To nLoops
x$=z$

Next i
t=timer

Print
Print "String = '"x$"'"
Timer=0
For i = 1 To nLoops
x$=z$
cltrim(x$,"0")
Next i
Print "Time for cLtrim:   ";(Timer-t)/nLoops*1000;"us (leading '0')"
Print ">";x$;"<",Len(x$)
Print

x$=z$
Print "Out of competition: Basic LTRIM from MMBasic manual
Print "String = '"x$"'"
Timer=0
For i = 1 To nLoops
x$=z$
a$=ltrix$(x$,"0")
Next i
Print "Time for LtriX:   ";(Timer-t)/nLoops*1000;"us (leading '0')"
Print ">";a$;"<",Len(a$)
Print


x$=   "0000000000000000000000000000000000000000" 
x$=x$+"000000000000000000000000000000000000000012345678" 
z$=x$

Timer=0
For i = 1 To nLoops
x$=z$

Next i
t=timer

Print "Out of competition: Basic LTRIM from MMBasic manual
Print "String = '"x$"'"
Timer=0
For i = 1 To nLoops
x$=z$
a$=ltrix$(x$,"0")
Next i
Print "Time for LtriX:   ";(Timer-t)/nLoops*1000;"us (leading '0')"
Print ">";a$;"<",Len(a$)
Print

Print "String = '"x$"'"
Timer=0
For i = 1 To nLoops
x$=z$
cltrim(x$,"0")
Next i
Print "Time for cLtrim:   ";(Timer-t)/nLoops*1000;"us (leading '0')"
Print ">";x$;"<",Len(x$)
Print


End '********************************************************



Function RTRIM(s$) as STRING
 cRtrim(S$)
 RTRIM=S$
End Function


Function LTRIM(s$) as STRING
 cLtrim(S$)
 LTRIM=S$
End Function


Function TRIM(s$) as STRING
 cRtrim(S$)
 cLtrim(S$)
 TRIM=S$
End Function


'Basic LTRIM from MMBasic manual
Function LTrix$(s$ as string, c$ as string) as string
LTrix$ = s$
Do While Instr(c$, Left$(LTrix$, 1))
LTrix$ = Mid$(LTrix$, 2)
Loop
End Function


'File cltrim.bas written 11-09-2020 20:14:20
CSUB cLtrim STRING, STRING
  00000000
  'ltrim
  B087B480 6078AF00 687B6039 73BB781B 75BB2300 613B687B 73FB2320 2B00687B 
  683BD031 D0062B00 785B683B E00273FB 33017DBB 7DBA75BB 429A7BBB 693BD207 
  613B3301 781B693B 429A7BFA 7BBAD0F0 1AD37DBB 687B73BB 701A7BBA 75FB2300 
  7DFAE00A 44137DBB 687B461A 7DFB441A 440B6879 701A7812 1C5A7DFB 7BBA75FA 
  D8EE429A BF00E000 46BD371C 7B04F85D 43474770 
End CSUB

'File crtrim.bas written 11-09-2020 22:22:18
CSUB cRtrim STRING,STRING
  00000000
  'rtrim
  B087B480 6078AF00 687B6039 73BB781B 75FB2300 613B687B 73FB2320 2B00687B 
  683BD020 D0022B00 785B683B 7BBB73FB 4413693A E002613B 33017DFB 7DFA75FB 
  429A7BBB 693BD806 613A1E5A 7BFA781B D0F1429A 7DFB7BBA 73BB1AD3 7BBA687B 
  E000701A 371CBF00 F85D46BD 47707B04 
End CSUB

'File ctrim.bas written 12-09-2020 19:39:28
CSUB ctrim STRING, STRING
  00000000
  'ctrim
  B087B480 6078AF00 687B6039 73BB781B 75BB2300 613B687B 73FB2320 2B00687B 
  683BD04C D0022B00 785B683B 7BBB73FB 4413693A E002613B 33017DBB 7DBA75BB 
  429A7BBB 693BD806 613A1E5A 7BFA781B D0F1429A 7DBB7BBA 73BB1AD3 75BB2300 
  613B687B 7DBBE002 75BB3301 7BBB7DBA D207429A 3301693B 693B613B 7BFA781B 
  D0F0429A 7DBB7BBA 73BB1AD3 7BBA687B 2300701A E00A75FB 7DBB7DFA 461A4413 
  441A687B 68797DFB 7812440B 7DFB701A 75FA1C5A 429A7BBA E000D8EE 371CBF00 
  F85D46BD 47707B04 
End CSUB